/*
 * Decompiled with CFR 0.152.
 */
package codersafterdark.reskillable.client.gui.handler;

import codersafterdark.reskillable.base.ConfigHandler;
import codersafterdark.reskillable.client.base.RenderHelper;
import codersafterdark.reskillable.client.gui.GuiAbilities;
import codersafterdark.reskillable.client.gui.GuiSkillInfo;
import codersafterdark.reskillable.client.gui.GuiSkills;
import codersafterdark.reskillable.client.gui.button.GuiButtonInventoryTab;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiContainerCreative;
import net.minecraft.client.gui.inventory.GuiInventory;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class InventoryTabHandler {
    public static String tooltip;
    public static int mx;
    public static int my;

    public static void addTabs(GuiScreen currScreen, List<GuiButton> buttonList) {
        if (!ConfigHandler.enableTabs) {
            return;
        }
        int x = currScreen.field_146294_l / 2 - 120;
        int y = currScreen.field_146295_m / 2 - 76;
        if (currScreen instanceof GuiContainerCreative) {
            x -= 10;
            y += 15;
        }
        buttonList.add(new GuiButtonInventoryTab(82931, x, y, GuiButtonInventoryTab.TabType.INVENTORY, gui -> gui instanceof GuiInventory || gui instanceof GuiContainerCreative));
        buttonList.add(new GuiButtonInventoryTab(82932, x, y + 29, GuiButtonInventoryTab.TabType.SKILLS, gui -> gui instanceof GuiSkills || gui instanceof GuiSkillInfo));
        buttonList.add(new GuiButtonInventoryTab(82933, x, y + 58, GuiButtonInventoryTab.TabType.ABILITIES, gui -> gui instanceof GuiAbilities));
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public static void initGui(GuiScreenEvent.InitGuiEvent.Post event) {
        if (event.getGui() instanceof GuiInventory || event.getGui() instanceof GuiContainerCreative) {
            InventoryTabHandler.addTabs(event.getGui(), event.getButtonList());
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public static void performAction(GuiScreenEvent.ActionPerformedEvent.Pre event) {
        if (event.getButton() instanceof GuiButtonInventoryTab) {
            GuiButtonInventoryTab tab = (GuiButtonInventoryTab)event.getButton();
            Minecraft mc = Minecraft.func_71410_x();
            switch (tab.type) {
                case INVENTORY: {
                    mc.func_147108_a((GuiScreen)new GuiInventory((EntityPlayer)mc.field_71439_g));
                    break;
                }
                case SKILLS: {
                    mc.func_147108_a((GuiScreen)new GuiSkills());
                    break;
                }
                case ABILITIES: {
                    mc.func_147108_a((GuiScreen)new GuiAbilities());
                }
            }
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public static void finishRenderTick(TickEvent.RenderTickEvent event) {
        if (event.phase == TickEvent.Phase.END && tooltip != null) {
            RenderHelper.renderTooltip(mx, my, Collections.singletonList(tooltip));
            tooltip = null;
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public static void onPotionShiftEvent(GuiScreenEvent.PotionShiftEvent event) {
        if (ConfigHandler.enableTabs) {
            event.setCanceled(true);
        }
    }

    public static int getPotionOffset() {
        return ConfigHandler.enableTabs ? 156 : 124;
    }
}

